/*---------------------------------------------*\
|  Netbook Robot Joystick Client v1.2		|
|  Switched to Joystick Class over functions	|
|  Adam Honse, Dec. 10 2009			|
\*---------------------------------------------*/

#include <iostream>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include "joystick.h"

using namespace std;

#define PORT "3490"

int main(int argc, char *argv[])
{
  Joystick controller("/dev/input/js0");

  addrinfo hints, *result;
  int fd;
  char buf[8];
  char m1[4];
  char m2[4];
  sockaddr_storage serv_addr;
  
  memset(&hints, 0, sizeof hints);

  hints.ai_family = AF_UNSPEC;
  hints.ai_socktype = SOCK_STREAM;

  getaddrinfo(argv[1], PORT, &hints, &result);

  fd = socket(result->ai_family, result->ai_socktype, result->ai_protocol);
  
  connect(fd, result->ai_addr, result->ai_addrlen);

  int motor1, motor2, numbytes;
  while(1)
  {
    controller.update();
    motor1 = controller.poll_axis(4);
    motor2 = controller.poll_axis(1);
    memcpy(&m1, &motor1, sizeof motor1);
    memcpy(&m2, &motor2, sizeof motor2);
    for(int i = 0; i < 4; i++)
    {
      buf[i] = m1[i];
    }
    for(int i = 4; i < 8; i++)
    {
      buf[i] = m2[i-4];
    }
    cout << "Sent: " << numbytes << " Bytes, " << (motor1/364)+90 << "		" << (motor2/364)+90 << endl;
    numbytes = send(fd,&buf,sizeof buf, 0);
    usleep(50000);
  }
  return 0;
}

  
